/*
 * Decompiled with CFR 0.152.
 */
package scene.controllers;

import graph.generator.ExcelReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.Set;
import javafx.beans.property.SimpleStringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.apache.commons.collections4.SetUtils;
import org.apache.commons.compress.utils.Sets;
import scene.controllers.GraphController;
import shared.Table;

public class MainController
implements Initializable {
    private final FileChooser fileChooser = new FileChooser();
    @FXML
    private AnchorPane mainAnchorPane;
    @FXML
    private Button chooseFileButton;
    @FXML
    private TableView<ObservableList<String>> tableView;
    @FXML
    private Button createGraph;
    private Table table;
    private GraphController graphController;
    private Stage graphStage;

    private File chooseFile() {
        Stage stage = (Stage)this.mainAnchorPane.getScene().getWindow();
        FileChooser.ExtensionFilter filter = new FileChooser.ExtensionFilter("File Excel (*.xlsx)", new String[]{"*.xlsx"});
        this.fileChooser.getExtensionFilters().add((Object)filter);
        File file = this.fileChooser.showOpenDialog((Window)stage);
        return file;
    }

    private void resetTable() {
        this.tableView.getColumns().clear();
        this.tableView.getItems().clear();
    }

    private void closeAllWindows() {
        this.graphStage.hide();
        this.graphController.onClose();
    }

    private void initColumn(TableColumn<ObservableList<String>, String> col) {
        col.setSortable(false);
        col.setCellFactory(TextFieldTableCell.forTableColumn());
        col.setStyle("-fx-alignment: CENTER;");
        col.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<ObservableList<String>, String>>(){

            public void handle(TableColumn.CellEditEvent<ObservableList<String>, String> t) {
                int row = t.getTablePosition().getRow();
                int column = t.getTablePosition().getColumn() - 1;
                String newVal = ((String)t.getNewValue()).trim();
                System.out.println("Edited cell Row: " + row + " Col: " + column);
                try {
                    Float valFloat = Float.valueOf(Float.parseFloat(newVal));
                    if (valFloat.floatValue() < 0.0f || valFloat.floatValue() > 1.0f) {
                        MainController.this.displayInvalidCellInput();
                        t.getTableView().refresh();
                        return;
                    }
                    MainController.this.table.setCellValue(valFloat, row, column);
                }
                catch (Exception e) {
                    if (newVal.equals("")) {
                        MainController.this.table.setCellValue(Float.valueOf(0.0f), row, column);
                    }
                    if (newVal.equals("x")) {
                        MainController.this.table.setCellValue(Float.valueOf(1.0f), row, column);
                    }
                    MainController.this.displayInvalidCellInput();
                    t.getTableView().refresh();
                    return;
                }
                System.out.println(MainController.this.table.toString());
                ((ObservableList)t.getTableView().getItems().get(row)).set(column + 1, (Object)newVal);
                MainController.this.closeAllWindows();
            }
        });
    }

    private void initItemsColumn(TableColumn<ObservableList<String>, String> col) {
        col.setCellFactory(cell -> new TableCell<ObservableList<String>, String>(){

            protected void updateItem(String item, boolean empty) {
                this.setText(item);
                this.setAlignment(Pos.CENTER);
            }
        });
        col.setCellValueFactory(data -> new SimpleStringProperty((String)((ObservableList)data.getValue()).get(0)));
        col.setSortable(false);
        col.setStyle("-fx-font-weight: bold");
    }

    public void tableFromFile() {
        File file = this.chooseFile();
        if (file == null) {
            return;
        }
        this.closeAllWindows();
        this.resetTable();
        this.table = new Table();
        ExcelReader reader = new ExcelReader(file.getAbsolutePath());
        reader.read(this.table);
        System.out.println(this.table);
        TableColumn colItems = new TableColumn(this.table.getName());
        this.initItemsColumn((TableColumn<ObservableList<String>, String>)colItems);
        this.tableView.getColumns().add((Object)colItems);
        int index = 1;
        for (String attr : this.table.getAttributesList()) {
            TableColumn tmpCol = new TableColumn(attr);
            this.initColumn((TableColumn<ObservableList<String>, String>)tmpCol);
            int i = index;
            if (SetUtils.difference(this.table.getPossibleValues(), (Set)Sets.newHashSet((Object[])new Float[]{Float.valueOf(0.0f), Float.valueOf(1.0f)})).isEmpty()) {
                tmpCol.setCellValueFactory(data -> new SimpleStringProperty(((String)((ObservableList)data.getValue()).get(i)).equals("1.0") ? "x" : ""));
            } else {
                tmpCol.setCellValueFactory(data -> new SimpleStringProperty((String)((ObservableList)data.getValue()).get(i)));
            }
            this.tableView.getColumns().add((Object)tmpCol);
            ++index;
        }
        this.fillTable();
    }

    public void fillTable() {
        ArrayList<ArrayList<Float>> m = this.table.getValuesList();
        for (int i = 0; i < m.size(); ++i) {
            ObservableList row = FXCollections.observableArrayList();
            row.add((Object)this.table.getItem(i));
            for (int j = 0; j < m.get(i).size(); ++j) {
                row.add((Object)Float.toString(m.get(i).get(j).floatValue()));
            }
            this.tableView.getItems().add((Object)row);
        }
        this.autoResizeColumns(this.tableView);
    }

    public void drawGraph() {
        if (this.table == null || this.table.isEmpty().booleanValue()) {
            this.displayNullTableError();
            return;
        }
        this.graphStage.show();
        this.graphController.createAndDrawGraph(this.table);
        this.graphController.onClose();
    }

    private void displayInvalidCellInput() {
        Alert dialog = new Alert(Alert.AlertType.ERROR);
        dialog.setTitle("Error");
        dialog.setContentText("A cell can only contains a number or the character 'x'");
        dialog.showAndWait();
    }

    private void displayNullTableError() {
        Alert dialog = new Alert(Alert.AlertType.ERROR);
        dialog.setTitle("Error");
        dialog.setHeaderText("Table not loaded, please load a new table using a .xlsx file");
        dialog.showAndWait();
    }

    public void autoResizeColumns(TableView<?> table) {
        table.setColumnResizePolicy(TableView.UNCONSTRAINED_RESIZE_POLICY);
        table.getColumns().stream().forEach(column -> column.setPrefWidth(table.getWidth() / (double)table.getColumns().size()));
    }

    public void initialize(URL location, ResourceBundle resources) {
        System.out.println("Initialize MainController");
        try {
            FXMLLoader loader = new FXMLLoader();
            FileInputStream fxmlStream = new FileInputStream("fxml/GraphScene.fxml");
            VBox root = (VBox)loader.load((InputStream)fxmlStream);
            this.graphController = (GraphController)loader.getController();
            Scene scene = new Scene((Parent)root);
            this.graphStage = new Stage();
            this.graphStage.setScene(scene);
            this.graphStage.setTitle("General Graph");
            this.graphStage.setOnCloseRequest(event -> this.graphController.onClose());
            this.graphStage.setMinHeight(300.0);
            this.graphStage.setMinWidth(400.0);
            fxmlStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.err.println("GraphScene.fxml not found!");
        }
    }
}

